package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestReviewTemplate extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		try {
			ReviewTemplate.findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
	}

	@Test
	public void testTwo() throws Exception {

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);

		ReviewTemplate rt = rtList.get(0);
		Assert.assertNotNull(rt);
		Assert.assertTrue(rt.getId() > 0);
		Assert.assertNotNull(rt.getName());
		Assert.assertTrue(rt.getName().length() > 0);
		
		ReviewTemplate rt2 = ReviewTemplate.findById(rt.getId());
		Assert.assertNotNull(rt2);
		Assert.assertEquals(rt2, rt);
	}

	@Test
	public void testThree() throws Exception {

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);

		ReviewTemplate rt = rtList.get(0);
		Assert.assertNotNull(rt);
		Assert.assertTrue(rt.getId() > 0);
		Assert.assertNotNull(rt.getReviewer());

		// really?  only one review template per reviewer?  that's an optimistic business rule
		ReviewTemplate rt2 = ReviewTemplate.findByGroupId(rt.getReviewer().getId());
		Assert.assertNotNull(rt2);
		Assert.assertEquals(rt2, rt);
	}

}
